﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

//HelpHomePage is a script for managing the help home page page UI
public class HelpHomePage : MonoBehaviour
{
    //UI Elements
    public GameObject PagesParent;
    public TextItemsSelector SectionsSelector;

    /// <summary>
    /// Handler for clicking Navigate, jumps to the correct page based on the selected index
    /// </summary>
    public void OnNavigateClicked()
    {
        switch(SectionsSelector.CurrentIndex)
        {
            case 0:
                PageManager.NavigateForward(PagesParent.FindChild("ConfigurationPage").GetComponent<PageDefinition>());
                break;

            case 1:
                PageManager.NavigateForward(PagesParent.FindChild("AdvConfigurationPage").GetComponent<PageDefinition>());
                break;

            case 2:
                PageManager.NavigateForward(PagesParent.FindChild("ControlsPage").GetComponent<PageDefinition>());
                break;

            case 3:
                PageManager.NavigateForward(PagesParent.FindChild("MoneyCarsPage").GetComponent<PageDefinition>());
                break;

            case 4:
                PageManager.NavigateForward(PagesParent.FindChild("MissionsPage").GetComponent<PageDefinition>());
                break;

            case 5:
                PageManager.NavigateForward(PagesParent.FindChild("TimeTrialPage").GetComponent<PageDefinition>());
                break;

            case 6:
                PageManager.NavigateForward(PagesParent.FindChild("CollectionPage").GetComponent<PageDefinition>());
                break;

            case 7:
                PageManager.NavigateForward(PagesParent.FindChild("WagerRacePage").GetComponent<PageDefinition>());
                break;
        }
    }
}
